trackcurrent=-1
trackbank=0
trackcounts={2,1}

function TIC()
  PlayTune()
end

function PlayTune()
 if peek(0x13ffc) == 255 then
   trackcurrent = trackcurrent + 1
   if trackcurrent==trackcounts[trackbank+1] 
   then 
     trackbank=trackbank+1
     sync(24,trackbank,false)
     trackcurrent=0
   end
   music(trackcurrent,-1,-1,false,true)
 end
 visdebug()
end

function visdebug()
  cls()
  print("bank:  " .. trackbank,10,10)
  print("track: " .. trackcurrent,10,20)
  print("other: " .. trackcounts[trackbank+1],10,30)
end

function vis()
 cls()
 for i=0,3 do
  value = peek(0xFF9C+18*i+1)<<8|peek(0xFF9C+18*i)
  volume = (value&0xf000)>>12
  for j=0,volume do
   rect(20+i*50+1,130-j*8+1,40,5,j/2+1)
   rect(20+i*50,130-j*8,40,5,j/2+2)
  end
 end
end
-- <TILES>
-- 001:eccccccccc888888caaaaaaaca888888cacccccccacc0ccccacc0ccccacc0ccc
-- 002:ccccceee8888cceeaaaa0cee888a0ceeccca0ccc0cca0c0c0cca0c0c0cca0c0c
-- 003:eccccccccc888888caaaaaaaca888888cacccccccacccccccacc0ccccacc0ccc
-- 004:ccccceee8888cceeaaaa0cee888a0ceeccca0cccccca0c0c0cca0c0c0cca0c0c
-- 017:cacccccccaaaaaaacaaacaaacaaaaccccaaaaaaac8888888cc000cccecccccec
-- 018:ccca00ccaaaa0ccecaaa0ceeaaaa0ceeaaaa0cee8888ccee000cceeecccceeee
-- 019:cacccccccaaaaaaacaaacaaacaaaaccccaaaaaaac8888888cc000cccecccccec
-- 020:ccca00ccaaaa0ccecaaa0ceeaaaa0ceeaaaa0cee8888ccee000cceeecccceeee
-- </TILES>

-- <WAVES>
-- 000:00000000ffffffff00000000ffffffff
-- 001:0123456789abcdeffedcba9876543210
-- 002:0123456789abcdef0123456789abcdef
-- 004:dffffeeeed00000000013a89aaaaaaaa
-- 008:0000000000000000ffffffffffffffff
-- 009:0000000000000fffffffffffffffffff
-- 010:000000000fffffffffffffffffffffff
-- 011:00000fffffffffffffffffffffffffff
-- 012:0122333445556666778899aaabbccdef
-- </WAVES>

-- <WAVES1>
-- 000:00000000ffffffff00000000ffffffff
-- 001:0123456789abcdeffedcba9876543210
-- 002:0123456789abcdef0123456789abcdef
-- 004:dffffeeeed00000000013a89aaaaaaaa
-- 008:0000000000000000ffffffffffffffff
-- 009:0000000000000fffffffffffffffffff
-- 010:000000000fffffffffffffffffffffff
-- 011:00000fffffffffffffffffffffffffff
-- 012:0122333445556666778899aaabbccdef
-- </WAVES1>

-- <SFX>
-- 000:00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b000000000
-- 001:03f703d71397237733674340540054005400540054005400540064006400640064006400b40eb40ea40ea403a40eb404b40eb40eb404b40eb40eb40e839000e48f53
-- 002:03007300d300e300e300e300e300f300f300f3000300030003000300030003000300030003000300030003000300030003000300030003000300030070a000810000
-- 003:03f710052004400340025000700e900da1fcb10bc10ad109e108f008f008f008f008f008f008f000f000f000f000f000f000f000f000f000f000f0009090810081e1
-- 004:f800e800e800d800b90099006900290009000a000a000a000a000a000b000b000b000b000b000b000a000a000a000a000a000900090009000900090010700d000000
-- 005:62006200623062305270b270f2a0f2a0f2c0f2c0f2f002f002b002b0f2b0020002000200020002000200020002000200020002000200020002000200302000040c00
-- 006:0800080008000800090009000900090009000a000a000a000a000a000b000b000b000b000b000b000a000a000a000a000a000900090009000900090020700d000000
-- 007:0bc05bc07bc0aac0ba00ca00d900d900e900e900a800b800d800e800e90009000900080008000b000b000b000b000b000b000b000b000b000b000b0020b00fa50900
-- 008:00f960c88350130053907300132053906300737073d083009300a350c360c300d300d390d300d3d0d360d300d300e390e300e320f320f310f310f300d94000000000
-- 009:030763087300830093009300a300a300b300c300c300c300d30003000300030003000300030003000300030003000300030003000300030003000300a77000c10002
-- 010:680038000800380068006800a800b800480078004800080038007800a800d800e800080008000800080008000800080008000800080008000800080030200f090000
-- 011:030043008300a300c300d300f300f3000300030003000300030003000300030003000300030003000300030003000300030003000300030003000300209000060000
-- 012:62006200623062305270b270f290f290f2c0f2c0f2f002f002b002b0f2b0020002000200020002000200020002000200020002000200020002000200209000040c00
-- 013:00f960c8835013005360734033275317630763077307830783068306930693069306a306a306b306c306c306d306d306d306d306d306d306e306e306d94000000000
-- 014:b308a308a309930b830c630d530e530f4300430133022303030403060306030703070307030703070307030703070307030703070307030703070307c05000000000
-- 015:01008100013001300170017001a001a00100010001000100010001000100010001000100010001000100010001000100010001000100010001000100369000020800
-- 016:01008100013001300150015001a001a00100010001000100010001000100010001000100010001000100010001000100010001000100010001000100469000020800
-- 017:0c004c008c508c509c80ac80acc0bcc0bc80cc80cc50cc50cc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00ec00ec00ec00409000000c00
-- 018:1c005c007c307c308c809c80acc0acc0bc80bc80bc30cc30cc00cc00cc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00ec00ec00ec00ec00ec00409000000c00
-- 019:1c003c005c506c507c708c708cc09cc0ac70bc70bc50cc50cc00cc00cc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00ec00ec00ec00ec00409000000c00
-- 020:1c003c005c307c308c709c70acc0bcc0bc70cc70cc30cc30cc00dc00dc00dc00dc00dc00ec00ec00ec00ec00ec00ec00ec00ec00ec00ec00ec00ec00409000000c00
-- </SFX>

-- <SFX1>
-- 000:00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b000000000
-- 001:03f703d71397237733674340540054005400540054005400540064006400640064006400b40eb40ea40ea403a40eb404b40eb40eb404b40eb40eb40e839000e48f53
-- 002:03007300d300e300e300e300e300f300f300f3000300030003000300030003000300030003000300030003000300030003000300030003000300030070a000810000
-- 003:03f710052004400340025000700e900da1fcb10bc10ad109e108f008f008f008f008f008f008f000f000f000f000f000f000f000f000f000f000f0009090810081e1
-- 004:f800e800e800d800b90099006900290009000a000a000a000a000a000b000b000b000b000b000b000a000a000a000a000a000900090009000900090010700d000000
-- 005:62006200623062305270b270f2a0f2a0f2c0f2c0f2f002f002b002b0f2b0020002000200020002000200020002000200020002000200020002000200302000040c00
-- 006:0800080008000800090009000900090009000a000a000a000a000a000b000b000b000b000b000b000a000a000a000a000a000900090009000900090020700d000000
-- 007:0bc05bc07bc0aac0ba00ca00d900d900e900e900a800b800d800e800e90009000900080008000b000b000b000b000b000b000b000b000b000b000b0020b00fa50900
-- 008:00f960c88350130053907300132053906300737073d083009300a350c360c300d300d390d300d3d0d360d300d300e390e300e320f320f310f310f300d94000000000
-- 009:030763087300830093009300a300a300b300c300c300c300d30003000300030003000300030003000300030003000300030003000300030003000300a77000c10002
-- 010:680038000800380068006800a800b800480078004800080038007800a800d800e800080008000800080008000800080008000800080008000800080030200f090000
-- 011:030043008300a300c300d300f300f3000300030003000300030003000300030003000300030003000300030003000300030003000300030003000300209000060000
-- 012:62006200623062305270b270f290f290f2c0f2c0f2f002f002b002b0f2b0020002000200020002000200020002000200020002000200020002000200209000040c00
-- 013:00f960c8835013005360734033275317630763077307830783068306930693069306a306a306b306c306c306d306d306d306d306d306d306e306e306d94000000000
-- 014:b308a308a309930b830c630d530e530f4300430133022303030403060306030703070307030703070307030703070307030703070307030703070307c05000000000
-- 015:01008100013001300170017001a001a00100010001000100010001000100010001000100010001000100010001000100010001000100010001000100369000020800
-- 016:01008100013001300150015001a001a00100010001000100010001000100010001000100010001000100010001000100010001000100010001000100469000020800
-- 017:0c004c008c508c509c80ac80acc0bcc0bc80cc80cc50cc50cc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00ec00ec00ec00409000000c00
-- 018:1c005c007c307c308c809c80acc0acc0bc80bc80bc30cc30cc00cc00cc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00ec00ec00ec00ec00ec00409000000c00
-- 019:1c003c005c506c507c708c708cc09cc0ac70bc70bc50cc50cc00cc00cc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00dc00ec00ec00ec00ec00409000000c00
-- 020:1c003c005c307c308c709c70acc0bcc0bc70cc70cc30cc30cc00dc00dc00dc00dc00dc00ec00ec00ec00ec00ec00ec00ec00ec00ec00ec00ec00ec00409000000c00
-- 021:33005300530063006300730073008300930093009300a300a300a300a300a300a300a300f300f300f300f300f300f300f300f300f300f300f300f300729000700000
-- </SFX1>

-- <PATTERNS>
-- 000:b00032000000000000000000000000000000b00032000000d0008a000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000d0008a000000000000000000000000000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000
-- 001:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b0002600000090002e000000b00026000000
-- 002:b00042000000000000000000000000000000b00042000000000000000000000000000000000000000000000000000000000000000000000000000000b00042000000000000000000000000000000000000000000000000000000000000000000b00042000000000000000000000000000000b00042000000000000000000000000000000000000000000000000000000000000000000000000000000b00042000000000000000000000000000000000000000000000000000000000000000000
-- 003:100400080500dff176000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 004:080000000000dff076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 005:d00442000000020000000000001000100000d00042000000000000000000000000100000000000000000d00064100000d00064100000d00064100000d00042000000000000000000000000000000000000000000d00066d06464000000000000d00042000000000000000000000000100000d00442000000000000000000000000100040000000000000d00064100000800066100000d00066100000d37046000000000000000000000000000000000000000000d00064000000000000000000
-- 006:400444000000020000000000001000100000400044000000000000000000000000100000000000000000400066100000400066100000400066100000400044000000000000000000000000000000000000000000402468000000400066000000600444000000000000000000000000100000600044000000000000000000000000000000000000000000610462000000000000000000000000000000600446000000000000000000000000000000000000000000b00064000000b02066000000
-- 007:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b000260000009ff12e000000b000260000009ff12e00000090002e000000b0009a00000000000000000090002e000000b00026000000
-- 008:d000a0dff4a6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 009:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d001b2d504ba0551000000000771000000000991000000000bb1000000000dd1000000000ff100000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00046000000d13462000000000000000000000000000000
-- 010:b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000d0008a000000000000000000d0008a000000b00032000000b00032000000d0008a000000000000000000000000000000000000000000
-- 011:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b000260000009ff12e000000b000260000009ff12e00000090002e000000b0009a000000000000030000100000000000000000000000
-- 012:000000000000d00076000000000000000000d00076000000000000000000000000000000d000780000000000000000000000000000008000780000000000000000008000780000000000000000000000000000009000780000000000000000000000000000009aa1780000000000000000000000000000009771780000000000000000000000000000009551780000000000000000000000000000009331780000001000000ff100d82546000000d12442000000000000000000000000000400
-- 013:b00032000000000000000000000000000000b00032000000d0008a000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000d0008a000000000000000000000000000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000
-- 014:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b000260000009ff12e000000b000260000009ff12e00000090002e000000b0009a000000000000000000000000000000000000000000
-- 015:000000000000d00076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000d81046000000000000000000000000000000000000080000
-- 016:d00442000000020000000000001000100000d00042000000000000000000000000100000000000000000d00064100000d00064100000d00064100000d00042000000000000000000000000000000000000000000d00066d06464000000000000d00042000000000000000000000000100000d00442000000000000000000000000100040000000000000d00064100000800066100000d00066100000d37046000000000000000000d00044000000000000000000000000000000000000000000
-- 017:b000b2000000b000b4000000b000b6000000b000b8000000d0008a000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000d0008a000000000000000000000000000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000
-- 018:d84554000000000000000000000000000000000000000000b0009a0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b0002600000090002e000000b00026000000
-- 019:d00056000000000000000000000000000000000000000000b00032000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 020:d00054000000000000000000000000000000000000000000d00066000000d08462000000000000000000d00464100000d00064100000d00064100000d00042000000000000000000000000000000000000000000d00066d06464000000000000d00042000000000000000000000000100000d00442000000000000000000000000100040000000000000d00064100000800066100000d00066100000d37046000000000000000000000000000000000000000000d00064000000000000000000
-- 021:b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000
-- 022:b00032000000000000000000000000000000b00032000000d0008a0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000b00032000000000000000000d0008a000000000000000000000000000000000000000000b000320000000000000000009ff12e000000b000320000000000000000009ff12e000000b000320000000000000000009ff12e000000b000320000009ff12e000000d8818adaa18adff18a100000000000000000000000000000000000100000
-- 023:9ff12e00000097312e0000009ff12e00000090002e00000090002e00000000000000000000000000000048356610000040006610000040006610000098052e000000000000000000b0009a000000000000000000000000000000000000000000681544000000000000000000000000100000682544000000000000000000000000100000683544000000000000000000000000100000684544000000609462000000000000100400b0009a000000000000000000000000000000000000000000
-- 024:000000000000d00076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000481546000000000000000000400064000000000000000000d80554000000000000000000600078000000d00054000000000000000000600078000000d00056000000000000000000600078000000d00056000000000000000000400078000000d00058000000000000000000000000000000000000000000
-- 025:400444000000020000000000001000100000400042000000000000000000000000000000000000000000400066100000400066100000400066100000400044000000000000000000400046000000000000000000402464000000000000000000600444000000000000000000000000100000600444000000000000000000000000100000600444000000000000000000000000100000600444000000609462000000000000100000600066000000012600000000000000000000000000000000
-- 026:b0009a00000000000000000000000000000000000000000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b0002600000090002e000000b00026000000
-- 027:180500000000dff176000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 028:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000b00032000000000000000000b00032000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000
-- 029:400444009000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000f00042000000000000000000f00042000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000000000000000000000000000f08464000000000000000000
-- 030:481544000400000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000f00042000000000000000000f00042000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000000000000000000000000000f08464000000000000000000
-- 031:d00432000000000000000000d08460000000000000000400d000a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dff4a40000000000000000000000000000000000000000000000000000000f0400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 032:d00444000000000000000000d08460000000000000000400d7f5a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dff4a40000000000000000000000000000000000000000000000000000000f0400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 033:b0049a000000000000000000000000000000000000000000d80556000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000c8000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 034:b0009a000000000000000000000000000000000000000000d815a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dff4a40000000000000000000000000000000000000000000000000000000f0400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 035:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000b00032000000000000000000b00032000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b00026000000d000da000000000000000000
-- 036:b0049a000000000000000000000000000000000000000000d815a20000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007024440000000000000000000000000000004c04a2000000000000000000000000000000000000000000000000000000080400000000000000000000000000000000050400000000000000000000000000000400
-- 037:d00444000000000000000000d08460000000000000000400d7f5a20000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007024440000000000000000000000000000004c04a2000000000000000000000000000000000000000000000000000000080400000000000000000000000000000000050400000000000000000000000000000400
-- 038:d00432000000000000000000d08460000000000000000400d000a20000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007024440000000000000000000000000000004c04a2000000000000000000000000000000000000000000000000000000080400000000000000000000000000000000050400000000000000000000000000000400
-- 039:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b00026000000d000e8000000000000000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d0008a000000e0008a000000f0008af0008a40008c40008c
-- 040:b0049a000000000000000000000000000000000000000000d80556000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000c8000000000000000000000000100000d000c8000000000000000000000000100000d000c8000000000000000000000000100000d000c8000000000000000000000000100000d000c8000000000000d804cc000000000000000000000000
-- 041:481544000400000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000404466000000000000000000f00042000000000000000000000000100000f00042000000000000000000000000100000600044000000000000000000000000100000600044000000000000000000000000100000800044000000000000000000b08462000000000000000000
-- 042:400444000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000404466000000000000000000f00042000000000000000000000000100000f00042000000000000000000000000100000600044000000000000000000000000100000600044000000000000000000000000100000800044000000000000000000b08462000000000000000000
-- 043:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000800032700032600032500032400032f00030e00030d00030
-- 044:b0049a000000000000000000000000000000000000000000d815a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dc04a0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b304bc000000000000000000000000000000000000000400
-- 045:d00444000000000000000000d08460000000000000000400d7f5a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dc04a0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b304bc000000000000000000000000000000000400
-- 046:d00432000000000000000000d08460000000000000000400d000a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dc04a0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 047:b00432000000000000000000000000000000000000000000d7c517000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d58017000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000d58017008000000000000000000000000000000000000000
-- 048:b0049a0000000000000000000000000000000000000000000ff1000000000ee1000000000dd1000000000cc1000000000bb1000000000aa100000000088100000000077100000000066100000000055100000000044100000000033100000000022100000000011100000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 049:000400000000000000000000000000000000000000000000d57037000000000000000000000000000000d57037000000000000000000000000000000000000000000000000000000d57037000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d57037000000000000000000000000000000d57037000000000000000000000000000000000000000000000000000000d57037000000000000000000000000000000000000000000
-- 050:000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000000000000000
-- 051:000000000000000000000000000000000000000000000000d38027000000000000000000000000000000d38027000000000000000000000000000000000000000000000000000000d38027000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d38027000000000000000000000000000000d38027000000000000000000000000000000000000000000000000000000d38027008000000000000000000000000000000000000000
-- 052:000400000000000000000000000000000000000000000000d58017000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d58017000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000d58017008000000000000000000000000000000000000000
-- 053:000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000
-- 054:000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000d37047000000000000000000000000d001b2d504ba0551000000000771000000000991000000000bb1000000000dd1000000000ff100000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00046000000d13462000000000000000000000000000000
-- </PATTERNS>

-- <PATTERNS1>
-- 000:b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000
-- 001:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d0005f0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e000000dff15f00000090002e00000090002e000000b0002600000090002e000000b00026000000
-- 002:080000000000dff076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000d0007800000000000000000040007800000040007a000000400078000000
-- 003:100400080500dff176000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 004:080000000000dff076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 005:d00444000000d06462000000001000100000d00442000000000000000000000000000000000000000000d00064100000d00066100000d00064100000d00042000000000000000000000000000000000000000000d00066d0646400000000000040004400000000000000000000000010000040044400000000000000000000000000000000000000000080006610000040006810000040006a100000437044000000000000000000000000000000000000000000400066000000000000000000
-- 006:600444000000020000000000001000100000600044000000000000000000000000000000000000000000600066100000600066100000600066100000600064000000000000000000000000000000000000000000602466000000600064000000400464000000000000000000000000100000400064000000000000000000000000000000407466000000000000000000e00442000000000000000000000000000000000000000000e0a464000000033600000000000000000400000000000600
-- 007:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d0005f0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b000260000009ff12e000000b000260000009ff12e00000090002e000000b0009a00000000000000000090002e000000b00026000000
-- 008:d000a0dff4a6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 009:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d001b2d504ba0551000000000771000000000991000000000bb1000000000dd1000000000ff100000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00046000000d13462000000000000000000000000000000
-- 010:b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000d0008a000000000000000000d0008a000000b00032000000b00032000000d0008a000000000000000000000000000000000000000000
-- 011:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b000260000009ff12e000000b000260000009ff12e00000090002e000000b0009a000000000000030000100000000000000000000000
-- 012:000000000000d00076000000000000000000d00076000000000000000000000000000000d000780000000000000000000000000000008000780000000000000000008000780000000000000000000000000000009000780000000000000000000000000000009aa1780000000000000000000000000000009771780000000000000000000000000000009551780000000000000000000000000000009331780000001000000ff100d82546000000d12442000000000000000000000000000400
-- 013:b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000000000000000000000000000
-- 014:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d0005f0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e000000b000260000009ff12e000000b00026000000dff1e8000000000000000000b0009a000000000000000000000000000000000000000000
-- 015:000000000000d00076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000800078000000000000000000400078000000e815a2000000000000000000000000000000000000080000
-- 016:60044400000000000000000000100010000060004400000000000000000000000000000000000000000060006210000060006410000060006810000060004600000000000000000000000000000000000000000060246800000060006600000040044400000000000000000000000010000040044400000000000000000000000000000000000000000080006610000040006810000040006a100000437044000000000000000000e000a2000000000000000000000000000000000000000000
-- 017:b000b8000000b000b6000000b000b4000000b000b2000000d0008a000000000000000000d0005f000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000
-- 018:d815a4000000000000000000000000000000000000000000b8059a0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d0005f0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e000000dff15f00000090002e00000090002e000000b0002600000090002e000000b00026000000
-- 019:d825a4000000000000000000000000000000000000000000b80532000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 020:d000a4000000000000000000000000000000000000000000d00066000000d08462000000000000000000d00464100000d00064100000d00064100000d00042000000000000000000000000000000000000000000d00066d06464000000000000400044000000000000000000000000100000400444000000000000000000000000000000000000000000d00064100000800066100000d00066100000437046000000000000000000000000000000000000000000d00064000000000000000000
-- 021:b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000000000000000000000000000
-- 022:b00032000000000000000000000000000000b00032000000d0008a0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000b00032000000000000000000d0008a000000000000000000000000000000000000000000b000320000000000000000009ff12e000000b000320000000000000000009ff12e000000b000320000000000000000009ff12e000000b000320000009ff12e000000d8818adaa18adff18a100000000000000000000000000000000000100000
-- 023:9ff12e00000097312e0000009ff12e00000090002e00000090002e000000000000000000000000000000681562b00062600064b00064600066b00066d81566000000000000000000b8059a000000000000000000000000000000000000000000981566000000000000000000000000000000982566000000000000000000000000100000b83566000000000000000000000000100000b84566000000b09468000000000000100400d00066000000000000000000000000000000000000000000
-- 024:000000000000d00076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000681566000000000000000000602468000000600066000000d80554000000000000000000600078000000d00054000000000000000000600078000000d00056000000000000000000600078000000d00056000000000000000000400078000000d00058000000000000000000000000000000000000000000
-- 025:600444000000000000000000001000100000600044000000000000000000000000000000000000000000600062b00062600064b00064600066b00066d00066000000000000000000600056000000000000000000602468000000600066000000900466000000000000000000000000100000900466000000000000000000000000100000b00466000000000000000000000000100000b00466000000b09468000000000000100000d00066000000012600000000000000000000000000000000
-- 026:b0009a00000000000000000000000000000000000000000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d0005f0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e000000dff15f00000090002e00000090002e000000b0002600000090002e000000b00026000000
-- 027:180500000000dff176000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000000000000000400078000000000000000000400078000000000000000000400078000000800078000000000000000000
-- 028:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000b00032000000000000000000b00032000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000
-- 029:400444009000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000f00042000000000000000000f00042000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000000000000000000000000000f08464000000000000000000
-- 030:481544000400000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000f00042000000000000000000f00042000000000000000000000000000000000000000000000000000000000000000000f00042000000000000000000000000000000000000000000f08464000000000000000000
-- 031:d00432000000000000000000d08460000000000000000400d000a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dff4a40000000000000000000000000000000000000000000000000000000f0400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 032:d00444000000000000000000d08460000000000000000400d7f5a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dff4a40000000000000000000000000000000000000000000000000000000f0400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 033:b0049a000000000000000000000000000000000000000000d80556000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000c8000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 034:b0009a000000000000000000000000000000000000000000d815a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dff4a40000000000000000000000000000000000000000000000000000000f0400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 035:b00032000000000000000000d000e8000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000b00032000000000000000000b00032000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b00026000000d000da000000000000000000
-- 036:100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 037:b0009a0000000000000000000000000000000000000000000ff1000ee1000dd1000cc1000bb1000aa100099100088100077100066100055100044100033100022100011100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 038:d00432000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 039:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b00026000000d000e8000000000000000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d0008a000000e0008a000000f0008af0008a40008c40008c
-- 040:b0049a000000000000000000000000000000000000000000d80556000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000c8000000000000000000000000100000d000c8000000000000000000000000100000d000c8000000000000000000000000100000d000c8000000000000000000000000100000d000c8000000000000d804cc000000000000000000000000
-- 041:481544000400000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000404466000000000000000000f00042000000000000000000000000100000f00042000000000000000000000000100000600044000000000000000000000000100000600044000000000000000000000000100000800044000000000000000000b08462000000000000000000
-- 042:400444000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000000000000000000000000000400044000000000000000000000000000000000000000000404466000000000000000000f00042000000000000000000000000100000f00042000000000000000000000000100000600044000000000000000000000000100000600044000000000000000000000000100000800044000000000000000000b08462000000000000000000
-- 043:b00032000000000000000000000000000000000000000000d0008a00000000000000000090002e000000b0002600000090002e000000b00026000000d000da00000000000000000090002e000000b0002600000090002e000000b00026000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000b00032000000d000da000000000000000000800032700032600032500032400032f00030e00030d00030
-- 044:b0049a000000000000000000000000000000000000000000d815a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dc04a0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b304bc000000000000000000000000000000000000000400
-- 045:d000a2000000d804a4000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 046:d815a2000000d804a4000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 047:b0009a000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b304bc000000000000000000000000000000000000000400
-- 048:b00032000000000000000000000000000000000000000000d0008a000000000000000000d0005f000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000d0008a000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000
-- 049:d00444000000d10462000000000000000000000000000000d000a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 050:d81544000000d10462000000001000000000000000000000d000a2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 051:000000000000000000000000000000000000000000000000d38027000000000000000000000000000000d38027000000000000000000000000000000000000000000000000000000d38027000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d38027000000000000000000000000000000d38027000000000000000000000000000000000000000000000000000000d38027008000000000000000000000000000000000000000
-- 052:000400000000000000000000000000000000000000000000d58017000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d58017000000000000000000000000000000d58017000000000000000000000000000000000000000000000000000000d58017008000000000000000000000000000000000000000
-- 053:000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000b00032000000000000000000000000000000000000000000
-- 054:000000000000000000000000000000000000000000000000d37047000000000000000000000000000000d37047000000000000000000000000000000000000000000000000000000d37047000000000000000000000000d001b2d504ba0551000000000771000000000991000000000bb1000000000dd1000000000ff100000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00046000000d13462000000000000000000000000000000
-- 055:080000000000dff076000000000000000000d00076000000000000000000000000000000d00078000000000000000000000000000000800078000000000000000000800078000000000000000000000000000000900078000000000000000000000000000000000000000000600078000000000000000000600078000000000000000000600078000000900078000000e81542000000000000000000000000000000000000000000e0a464000000036600000000000000000400080500000600
-- 056:9ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d0005f0000000000000000009ff12e00000097312e0000009ff12e00000090002e00000090002e0000000000000000009ff12e00000097312e0000009ff12e00000090002e000000d000e8000000000000000000b0009a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 057:b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000000000000000000000000000000000000000b00032000000000000000000d0008a000000000000000000d0005f000000000000000000b00032000000000000000000d0005f000000b00032000000d0008a000000000000000000d0005f000000d0008a000000b00032000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 058:60044400000000000000000000100010000060004400000000000000000000000000000000000000000060046210000060006410000060006810000060004600000000000000000000000000000000000000000060246800000060006600000040044400000000000000000000000010000040044400000000000000000000000000000000000000000080006610000040006810000040006a100000437044000000000000000000000000000000000000000000400066000000000000000000
-- </PATTERNS1>

-- <TRACKS>
-- 000:080400002500080500002500690500612500690500b03d821c6c911025811805811025c1180581ec30542d44557169960000df
-- 001:d98f974e8128d98f974696e9d98f974e812886aaeac6beeb07c44d43050d23058c3305cc5b054d43250d2b058c733d8d0000df
-- 003:0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003bf
-- 004:0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003bf
-- 005:0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003bf
-- 006:0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003bf
-- 007:0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003bf
-- </TRACKS>

-- <TRACKS1>
-- 000:1c6c911023ce180581a7e8f11c6581ec30542d4455a7e8f142c3bc82cfab7a95690000000000000000000000000000000000df
-- </TRACKS1>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

